/**
 * 
 */
package com.ejie.ab18a.control.mantenimiento;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab18a.model.Ab18aTipoPeticion;
import com.ejie.ab18a.service.Ab18aTipoPeticionService;
import com.ejie.ab18a.utils.Constantes;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.Pagination;

/**
 * @author XXXX
 * 
 */
@Controller
@RequestMapping(value = "/tipoEnvio")
public class Ab18aTipoEnvioController {

	/** The Constant logger. */
	private static final Logger logger = LoggerFactory.getLogger(Ab18aTipoEnvioController.class);

	@Autowired
	private Ab18aTipoPeticionService ab18aTipoEnvioService;

	@Autowired
	private ReloadableResourceBundleMessageSource messageSource;

	/**
	 * Method 'getCreateForm'. Llamado para cargar el mantenimiento de tipos de
	 * envio
	 * 
	 * @param idExpediente
	 *            Long
	 * @param model
	 *            Model
	 * @return ModelAndView
	 */
	// @RequestMapping(value = "mantenimiento", method = RequestMethod.GET)
	// public ModelAndView getCreateFormTipoEnvio(Model model) {
	// Ab18aTipoEnvioController.logger.error("[GET - View] : ab18aTipoEnvioMantenimiento");
	// return new ModelAndView("ab18aTipoEnvioMantenimiento", "model", model);
	// }

	@RequestMapping(value = "mantenimiento", method = RequestMethod.GET)
	public String viewDetalle() {
		logger.info("mantenimiento");
		return "ab18aTipoEnvioMantenimiento";
	}

	/** Buscamos las peticiones correspondientes a los valores del filtro **/
	@RequestMapping(value = "mantenimiento/tabla", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridResponseDto<Ab18aTipoPeticion> buscarPeticiones(@ModelAttribute() Ab18aTipoPeticion tipoPeticion,
			@ModelAttribute() JQGridRequestDto request, @ModelAttribute() Pagination pagination) {

		List<Ab18aTipoPeticion> listaEnvios = new ArrayList<Ab18aTipoPeticion>();
		Long recordNum = Long.valueOf("12125");
		try {
			listaEnvios = this.ab18aTipoEnvioService.findAllLike(tipoPeticion, request, false);
			recordNum = this.ab18aTipoEnvioService.findAllLikeCount(tipoPeticion, false);
		} catch (Exception e) {
			Ab18aTipoEnvioController.logger.error("Ab18aMonitorController - buscarPeticiones() - Error al obtener las peticiones - " + e);
		}

		JQGridResponseDto<Ab18aTipoPeticion> response = new JQGridResponseDto<Ab18aTipoPeticion>(request, recordNum, listaEnvios);
		// return new JQGridJSONModel(pagination, recordNum, listaEnvios);
		return response;
	}

	/**
	 * Method 'guardarMantenimiento'.
	 * 
	 * @param mantenimiento
	 *            Y96bMantenimiento
	 * @return Y96bMantenimiento
	 * @throws Exception
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Ab18aTipoPeticion guardarMantenimiento(@RequestBody Ab18aTipoPeticion mantenimiento, HttpServletResponse response) throws Exception {
		Ab18aTipoPeticion mantenimientoAux = null;

		if (mantenimiento.getT02IdTipoEnvio() != null && mantenimiento.getT02IdTipoEnvio() > 0) {
			/**
			 * idRegistro > 0 implica que es una modificación.
			 */
			mantenimientoAux = this.ab18aTipoEnvioService.update(mantenimiento);
			Ab18aTipoEnvioController.logger.info("[POST] : Ab18aTipoPeticion mantenimiento actualizado correctamente");
		} else {
			if (this.ab18aTipoEnvioService.findTipoEnvioByCod(mantenimiento.getT02CodTipoEnvio()) <= 0) {
				/**
				 * Si tenemos idRegistro vacío es un alta de registro
				 */
				try {
					mantenimientoAux = this.ab18aTipoEnvioService.add(mantenimiento);
					Ab18aTipoEnvioController.logger.info("[POST] : Ab18aTipoPeticion mantenimiento insertado correctamente");
				} catch (Exception e) {
					Ab18aTipoEnvioController.logger.error("[POST] : Ab18aTipoPeticion error al añadir un registro al mantenimiento: " + e);
					throw e;
				}
			} else {
				response.sendError(Constantes.HTTP_STATUS_EXPECTATION_FAILED,
						this.messageSource.getMessage("mantenimientos.validacion.codigoRepetido", null, LocaleContextHolder.getLocale()));
			}
		}

		return mantenimientoAux;
	}

	/**
	 * @param messageSource
	 *            ReloadableResourceBundleMessageSource-.
	 */
	public void setMessageSource(ReloadableResourceBundleMessageSource messageSource) {
		this.messageSource = messageSource;
	}
}
